# 機能設計書 36-Scroll To Top設定

## 概要

本ドキュメントは、QuickerSite CMSにおけるページ上部へ戻るボタン（Scroll To Top）の設定機能の設計を記述する。

### 本機能の処理概要

Scroll To Top設定機能は、長いページをスクロールした際に表示される「ページ上部へ戻る」ボタンの設定を管理する機能である。複数のアイコンデザインから選択でき、サイトのデザインに合わせたボタンを設置できる。

**業務上の目的・背景**：
長いコンテンツページでは、ユーザーがページ上部に戻るためにスクロールする必要があり、ユーザビリティが低下する。本機能により、ワンクリックでページ上部に戻れるボタンを設置でき、ユーザー体験を向上させることができる。

**機能の利用シーン**：
- 長いブログ記事やFAQページにスクロールトップボタンを追加したい場合
- サイトのデザインに合わせた矢印アイコンを選択したい場合
- ボタンを非表示にしたい場合

**主要な処理内容**：
1. fixedImages/arrowsディレクトリから利用可能なアイコン一覧を取得
2. ラジオボタンで「なし」または任意のアイコンを選択
3. 選択されたアイコンファイル名をデータベースに保存
4. フロントエンドでjQueryによるスムーズスクロールを実装

**関連システム・外部連携**：
- tblCustomerテーブル（顧客設定情報の永続化）
- fixedImages/arrowsディレクトリ（アイコン画像）
- jQuery（フロントエンドアニメーション）

**権限による制御**：
- 管理者権限が必要（bs_security.aspによる認証）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 93 | 矢印アップ設定 | 主画面 | スクロールトップボタンの設定 |

## 機能種別

設定管理 / CRUD操作（Update）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| postback | String | Yes | ポストバック判定 | "1"固定 |
| sArrowUP | String | No | 選択されたアイコンファイル名 | 空文字列または有効なファイル名 |

### 入力データソース

- 画面入力（ラジオボタン）
- fixedImages/arrowsディレクトリからの動的ファイル一覧

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| customer.sArrowUP | String | 選択されたアイコンファイル名 |

### 出力先

- tblCustomerテーブル（設定の永続化）
- 画面（設定完了後のリダイレクト）

## 処理フロー

### 処理シーケンス

```
1. ページ読み込み
   └─ fixedImages/arrowsディレクトリからアイコン一覧を取得
   └─ 既存設定（customer.sArrowUP）を読み込み
2. アイコン選択
   └─ 「No arrow」または各アイコンからラジオボタンで選択
3. 保存ボタン押下（postback）
   └─ sArrowUPを取得
   └─ customer.save()で保存
   └─ リダイレクト
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ページ読み込み]
    B --> C[arrowsフォルダをスキャン]
    C --> D[アイコン一覧表示]
    D --> E{postback?}
    E -->|Yes| F[sArrowUP取得]
    E -->|No| G[フォーム表示]
    F --> H[customer.save]
    H --> I[リダイレクト]
    I --> J[終了]
    G --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-036-1 | ボタン非表示 | sArrowUPが空の場合はボタンを表示しない | フロントエンド表示時 |
| BR-036-2 | フェードイン表示 | スクロール位置が220px以上でボタンが表示される | フロントエンド |
| BR-036-3 | スムーズスクロール | ボタンクリックで500msのアニメーションでトップに戻る | フロントエンド |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定保存 | tblCustomer | UPDATE | スクロールトップ設定の更新 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sArrowUP | アイコンファイル名または空文字 | 選択されたアイコン |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 認証エラー | ログインしていない場合 | ログイン画面へリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

customer.save()メソッド内でトランザクション管理。

## パフォーマンス要件

- レスポンス時間: 1秒以内
- ディレクトリスキャンは同期的に実行

## セキュリティ考慮事項

- bs_security.aspによる管理者認証
- FileSystemObjectでの安全なディレクトリ読み取り

## 備考

- アイコンはfixedImages/arrowsディレクトリに配置
- 新しいアイコンを追加する場合はディレクトリにファイルを配置するだけで利用可能
- jQuery依存のアニメーション処理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | customer.asp | `asp/includes/customer.asp` | sArrowUPプロパティ（18行目、219行目、464行目） |

**読解のコツ**: sArrowUPは選択されたアイコンファイル名を保持する文字列プロパティ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_arrowup.asp | `asp/bs_arrowup.asp` | メイン処理ファイル |

**主要処理フロー**:
1. **7-14行目**: postback処理（保存）
2. **35-48行目**: FileSystemObjectでarrowsディレクトリをスキャン
3. **42-46行目**: 各ファイルに対してラジオボタンを生成

#### Step 3: フロントエンドでの使用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | getArrowJS関数（1612-1621行目）、getArrowCSS関数（1624-1634行目） |

**主要処理フロー**:
- **1612-1621行目**: jQueryスクロールイベントとアニメーション生成
- **1624-1634行目**: ボタン位置固定用CSS生成

### プログラム呼び出し階層図

```
bs_arrowup.asp
    │
    ├─ begin.asp（共通初期化）
    │      └─ customer.asp（customerオブジェクト定義）
    │
    ├─ bs_security.asp（認証チェック）
    │
    ├─ FileSystemObject.getFolder()（ディレクトリスキャン）
    │      └─ fixedImages/arrows/
    │
    └─ customer.save()（設定保存）
           └─ tblCustomer UPDATE
```

### データフロー図

```
[入力]               [処理]                    [出力]

fixedImages/arrows/ ──▶ bs_arrowup.asp ───▶ フォーム表示
                            │
ラジオボタン選択 ──────────▶│
                            ▼
                      customer.save()
                            │
                            ▼
                      tblCustomer
                            │
                            ▼
                      getArrowJS() ───▶ フロントエンドJS
                      getArrowCSS() ──▶ フロントエンドCSS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_arrowup.asp | `asp/bs_arrowup.asp` | ソース | スクロールトップ設定画面 |
| customer.asp | `asp/includes/customer.asp` | ソース | 顧客設定クラス・JS/CSS生成 |
| arrows/ | `fixedImages/arrows/` | 画像 | アイコン画像ディレクトリ |
